IF NOT EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'KYScriptLog'
      AND SO.[type] = 'U')
  BEGIN
    -- Drop new Schema Bound objects so they don't interfere with
    -- the re-running of scripts
    IF EXISTS
      (SELECT TOP 1 1
         FROM SYS.[objects] SO
        WHERE SO.[name] = 'OpenMattersOnly'
          AND SO.[type] = 'V')
      BEGIN
        EXEC ('DROP VIEW [dbo].[OpenMattersOnly]')
      END
  END
GO

IF NOT EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'KYScriptLog'
      AND SO.[type] = 'U')
  BEGIN
    CREATE TABLE [dbo].[KYScriptLog]
                ([id]                     INT               IDENTITY(1, 1),
                 [timestamp]              DATETIME          NOT NULL,
                 [COMMENT]                VARCHAR(MAX)      NOT NULL,
                 [CompatibleVersion]      VARCHAR(50)       NOT NULL,
                 CONSTRAINT [PK_KYScriptLog] PRIMARY KEY CLUSTERED
                           ([id]))
              ON [PRIMARY]
  END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'KYScriptLog'
      AND SO.[type] = 'U')
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[columns] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'MajorVersion'
        WHERE SO.[name] = 'KYScriptLog'
          AND SO.[type] = 'U')
      BEGIN
        ALTER TABLE [dbo].[KYScriptLog] ADD [MajorVersion] INT
        ALTER TABLE [dbo].[KYScriptLog] ADD [MinorVersion] INT
        ALTER TABLE [dbo].[KYScriptLog] ADD [Build] INT
        ALTER TABLE [dbo].[KYScriptLog] ADD [Revision] INT
      END
  END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'KYScriptLog'
      AND SO.[type] = 'U')
  BEGIN
    IF NOT EXISTS
      (SELECT *
         FROM SYS.[objects] SO
              INNER JOIN SYS.[indexes] SC
                      ON SC.[object_id] = SO.[object_id]
                     AND SC.[name] = 'IX_Version'
        WHERE SO.[name] = 'KYScriptLog'
          AND SO.[type] = 'U')
      BEGIN
        CREATE NONCLUSTERED INDEX [IX_Version]
            ON [dbo].[KYScriptLog]
              ([MajorVersion]  ASC,
               [MinorVersion]  ASC,
               [Build]         ASC,
               [Revision]      ASC)
               INCLUDE ([CompatibleVersion])
      END
  END
GO

SET NOCOUNT ON

UPDATE [dbo].[KYScriptLog]
   SET [MajorVersion] = 5,
       [MinorVersion] = 1,
       [Build] = 1,
       [Revision] = 155
 WHERE [CompatibleVersion] = 'Build 5.1.1.155'
GO

DECLARE @Language VARCHAR(20)

SELECT @Language = SL.[language]
  FROM sys.syslogins SL
 WHERE SL.loginname = 'keyhouse'

IF @Language NOT IN ('us_english', 'British')
  BEGIN
    EXEC ('ALTER LOGIN keyhouse WITH DEFAULT_LANGUAGE = us_english')
  END
GO

DECLARE @Language VARCHAR(20)

SELECT @Language = SL.[language]
  FROM sys.syslogins SL
 WHERE SL.loginname = 'client'

IF @Language NOT IN ('us_english', 'British')
  BEGIN
    EXEC ('ALTER LOGIN client WITH DEFAULT_LANGUAGE = us_english')
  END
GO

IF NOT EXISTS
  (SELECT TOP 1 1
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'BespokeObjects'
      AND SO.[type] = 'U')
BEGIN
  CREATE
   TABLE [dbo].[BespokeObjects]
        ([objectname]           NVARCHAR(128)             NOT NULL,
         CONSTRAINT [PK_BespokeObjects]
                    PRIMARY KEY CLUSTERED
                   ([objectname])
                 ON [PRIMARY])
      ON [PRIMARY]
END
GO

DELETE [dbo].[BespokeObjects]
GO

IF EXISTS
  (SELECT TOP 1 1
     FROM sys.triggers ST
    WHERE ST.[name] = 'NO_DROP_TABLE')
BEGIN
  INSERT
    INTO [dbo].[BespokeObjects]
        ([objectname])
  VALUES(N'NO_DROP_TABLE')

  EXEC ('DROP TRIGGER [NO_DROP_TABLE] ON DATABASE')
END
GO

IF EXISTS
  (SELECT *
     FROM SYS.[objects] SO
    WHERE SO.[name] = 'ky_GetDatabaseCompatibleVersionLog'
      AND SO.[type] = 'P')
BEGIN
  DROP PROCEDURE [dbo].[ky_GetDatabaseCompatibleVersionLog]
END
GO

CREATE PROCEDURE 
       [dbo].[ky_GetDatabaseCompatibleVersionLog]
AS
/******************************************************************************
 *
 * [dbo].[ky_GetDatabaseCompatibleVersionLog]
 *
 *
 ******************************************************************************/
BEGIN
  SELECT KSL.[timestamp],
         KSL.[CompatibleVersion],
         KSL.[COMMENT]
    FROM [dbo].[KYScriptLog] KSL
ORDER BY KSL.[MajorVersion] DESC,
         KSL.[MinorVersion] DESC,
         KSL.[Build] DESC,
         KSL.[Revision] DESC,
         KSL.[TimeStamp] DESC
END
GO

DELETE KY2
  FROM (SELECT MAX(KYC.[ID]) AS [MAXID]
          FROM [dbo].[kyscriptlog] KYC
         WHERE KYC.[COMMENT] LIKE '% complete') KYM
       INNER JOIN [dbo].[kyscriptlog] KY2
               ON KY2.[id] > KYM.[MAXID]
GO